/* Simple Console (DOS box) application for polled mode Analog Input

   Tested with KPCMCIA-12AIAO-C in Win2K SP4 using KPCMCIA-850A04.0.0.2

*/

#include <windows.h>  //  need these include files
#include <iostream.h>
#include <iomanip.h>
#include "drvlinx.h"  // copied these to the project's folder
#include "dlcodes.h"

void showMessage(DL_ServiceRequest *SR);
HINSTANCE DriverInst;
DL_ServiceRequest * SerReq;


void showMessage(DL_ServiceRequest *SR)
{
	if(SR->result!=0)
	{
		SR->operation=MESSAGEBOX;
		DriverLINX(SR);
		exit(0);
	}
	return;
}



int main(int argc, char* argv[])
{

	//Open the driver, in this case the kpcaiao for the KPCMCIA multi-function boards
	// OpenDriverLINX function wants a valid window handle in anticipation
	// that we might make use of Windows Messages.  Use of Messages is not
	// relavent to our DOS-box application so just pass the handle of the desktop to this function
	DriverInst = OpenDriverLINX(GetDesktopWindow(), "kpcaiao");

	/*
      Use "kpci3100" for KPCI-3101, etc.:  Boards from the KPCI-3100 Series
	  Use "kpci3108" for KPCI-3107 or KPCI-3108
	  Use "kpci1800" for KPCI-1801HC or KPCI-1802HC
	  Use "kmb1800" for ISA bus boards in the DAS-1800 Series

      If driver loading fails, the OpenDriverLINX dialog will appear (to give second chance).

	  Append a $ onto end of driver name to suppress the dialog, e.g., "kpcaiao$"
    */
	
	// allocate the SR structure
	SerReq = (DL_ServiceRequest*) new DL_ServiceRequest;
	memset(SerReq,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*SerReq);
	
	// use the SR structure to initialize the hardware
	SerReq->device=0;  // the device number assigned in DLinx Config Panel
	SerReq->operation=INITIALIZE;
	SerReq->mode=OTHER;
	SerReq->subsystem=DEVICE;
	SerReq->hWnd=GetDesktopWindow();
	DriverLINX(SerReq);  // carry out the INITIALIZE operation
	showMessage(SerReq);  // call the error checking routine

	//now modify the members of the structure to carry out a POLLED mode START operation
	SerReq->subsystem = AI;
	SerReq->operation = START;
	SerReq->mode=POLLED;
	SerReq->channels.nChannels=1;  // only a start channel will be specified
	SerReq->channels.chanGain[0].channel=0;  // that channel is chan 0
	SerReq->channels.chanGain[0].gainOrRange=Gain2Code(0,AI,-1.0);  // bipolar gain of 1
	SerReq->status.typeStatus=IOVALUE;  // in the ioValue member we'll get our data
	DriverLINX(SerReq);  // carry out the START operation
	showMessage(SerReq);  // error check


	// the Code2Volts function can convert the raw A/D counts to
	// the corresponding voltage, but it does this correctly
	// only when the default range of bipolar gain of 1 is used
	float volts;
	int result;
	result = Code2Volts(0, AI, SerReq->status.u.ioValue,&volts);
	cout<<setprecision(4)<<"Measured Value is: "<<volts<<"\n\n";
	
	// on exit, close the driver and set the structures to null
	
	CloseDriverLINX(DriverInst);
	delete (SerReq);
	DriverInst = NULL;
	SerReq = NULL;   
	
	return 0;
}

